﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Diagnostics ' 针对 Process.Start
Imports System.IO

Class FileListView
    Inherits ListView
    Private strDirectory As String

    Public Sub New()
        ' 将默认 View 枚举设置为 Details。
        Me.View = System.Windows.Forms.View.Details

        ' 获取将用作某些常见文件类型图标的图像。
        Dim img As New ImageList()
        With img.Images
            .Add(My.Resources.DOC)
            .Add(My.Resources.EXE)
        End With

        ' ListView 的大小图像列表使用同一
        ' 图像集。
        Me.SmallImageList = img
        Me.LargeImageList = img

        ' 创建列。
        With Columns
            .Add("Name", 100, HorizontalAlignment.Left)
            .Add("Size", 100, HorizontalAlignment.Right)
            .Add("Modified", 100, HorizontalAlignment.Left)
            .Add("Attribute", 100, HorizontalAlignment.Left)
        End With
    End Sub

    ''' <summary>
    ''' 重写基类 OnItemActivate 事件处理程序。扩展该
    ''' 基类实现以运行任何 .exe 或与可执行文件关联的文件。
    ''' </summary>
    Protected Overrides Sub OnItemActivate(ByVal ea As EventArgs)
        MyBase.OnItemActivate(ea)

        Dim lvi As ListViewItem
        For Each lvi In SelectedItems
            Process.Start(Path.Combine(strDirectory, lvi.Text))
        Next lvi
    End Sub

    ''' <summary>
    ''' 此子例程用于显示用户当前从自定义
    ''' TreeView 控件中选择的目录中的所有文件列表。
    ''' </summary>
    Public Sub ShowFiles(ByVal strDirectory As String)
        ' 将目录名另存为字段。
        Me.strDirectory = strDirectory

        Items.Clear()

        Dim diDirectories As New DirectoryInfo(strDirectory)
        Dim afiFiles() As FileInfo

        Try
            ' 调用简便的 GetFiles 方法以获取包含目录中
            ' 所有文件的数组。
            afiFiles = diDirectories.GetFiles()
        Catch
            Return
        End Try

        Dim fi As FileInfo
        For Each fi In afiFiles
            ' 创建 ListViewItem。
            Dim lvi As New ListViewItem(fi.Name)

            ' 基于文件扩展名分配 ImageIndex。
            Select Case Path.GetExtension(fi.Name).ToUpper()
                Case ".EXE"
                    lvi.ImageIndex = 1
                Case Else
                    lvi.ImageIndex = 0
            End Select

            ' 添加文件长度和上次修改时间这两个子项。
            lvi.SubItems.Add(fi.Length.ToString("N0"))
            lvi.SubItems.Add(fi.LastWriteTime.ToString())

            ' 添加属性子项。
            Dim strAttr As String = ""

            If (fi.Attributes And FileAttributes.Archive) <> 0 Then
                strAttr += "A"
            End If
            If (fi.Attributes And FileAttributes.Hidden) <> 0 Then
                strAttr += "H"
            End If
            If (fi.Attributes And FileAttributes.ReadOnly) <> 0 Then
                strAttr += "R"
            End If
            If (fi.Attributes And FileAttributes.System) <> 0 Then
                strAttr += "S"
            End If
            lvi.SubItems.Add(strAttr)

            ' 将完成的 ListViewItem 添加到 FileListView。
            Items.Add(lvi)
        Next fi
    End Sub

End Class